<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="mt-lg-0">
            <div class="card" id="basic-info">
                <div class="card-header">

                    <div class="float-end">
                        <a href="/projects" type="button" class="btn btn-sm btn-info">
                            <?php echo e(__('Product Plans')); ?>

                        </a>
                        <a href="/create-project?id=<?php echo e($project->id); ?>" type="button"
                           class="btn btn-sm bg-gradient-secondary"><?php echo e(__('Edit')); ?></a>
                    </div>
                    <span>
                        <h5 class=""><?php echo e($project->title); ?></h5>
                        <span class="badge bg-purple-light  font-weight-bold"><?php echo e($project->status); ?></span></span>
                </div>
                <div class="ms-4">
                    <div class="pt-0">
                        <div class="row">
                            <div class="col-md-2">
                                <span>
                                    <div class="ms-auto">
                                        <span class="badge badge-sm bg-gradient-faded-light text-dark fw-bolder mb-1">
                                        <?php if(!empty($project->start_date)): ?>
                                        <?php echo e($project->start_date->format(config('app.date_format'))); ?>

                                        <?php endif; ?>
                                        </span>
                                        <p class="text-sm fw-bolder text-black-50"><?php echo e(__('Start date')); ?></p>
                                    </div>
                                </span>
                            </div>
                            <div class="col-md-2">
                                <span>
                                   <div class="ms-auto">
                                    <span class="badge badge-sm bg-gradient-faded-light text-dark fw-bolder mb-1">
                                    <?php if(!empty($project->end_date)): ?>
                                    <?php echo e($project->end_date->format(config('app.date_format'))); ?>

                                     <?php endif; ?>
                                    </span>
                                    <p class="text-sm fw-bolder text-black-50"><?php echo e(__('Due date')); ?></p>
                                   </div>
                                </span>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex">
                                    <?php if($project->members): ?>
                                        <?php $__currentLoopData = json_decode($project->members); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset($users[$member])): ?>
                                                <div class="col-md-2 text-center">

                                                    <?php if(!empty($users[$member]->photo)): ?>
                                                        <a href="javascript:"
                                                           class="avatar avatar-md rounded-circle border border-secondary">
                                                            <img class="p-1"
                                                                 src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($users[$member]->photo); ?>">
                                                        </a>
                                                    <?php else: ?>
                                                        <div
                                                            class="avatar avatar-md rounded-circle bg-purple-light  border-radius-md p-2"> <h6 class="text-purple mt-1"><?php echo e($users[$member]->first_name[0]); ?><?php echo e($users[$member]->last_name[0]); ?></h6>
                                                        </div>
                                            <?php endif; ?>
                                       <p class="mb-0 text-sm"><?php echo e($users[$member]->first_name); ?></p>
                                        </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    <div class="col-md-2 text-center">
                                        <a href="/create-project?id=<?php echo e($project->id); ?>"
                                           class="avatar avatar-md border-1 rounded-circle bg-gradient-light">
                                            <i class="fas fa-plus text-white"></i>
                                        </a>
                                    </div>
                               </div>
                           </div>
                       </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <a class="btn btn-sm btn-success " data-bs-toggle="" href="/view-project?id=<?php echo e($project->id); ?>"
                           role="button" aria-selected="true">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                 fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                 stroke-linejoin="round" class="feather feather-file-text">
                                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                <polyline points="14 2 14 8 20 8"></polyline>
                                <line x1="16" y1="13" x2="8" y2="13"></line>
                                <line x1="16" y1="17" x2="8" y2="17"></line>
                                <polyline points="10 9 9 9 8 9"></polyline>
                            </svg>
                            <span class="ms-1"><?php echo e(__('Overview')); ?></span>
                        </a>
                        <a class="btn btn-sm btn-info " data-bs-toggle=""
                           href="/view-project-discussion?id=<?php echo e($project->id); ?>" role="button" aria-selected="false">


                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"
                                 fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                 stroke-linejoin="round" class="feather feather-message-square">
                                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                            </svg>
                            <span class="ms-1"><?php echo e(__('Discussions')); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12 col-lg-8">
            <div class="card">
                <div class="card-body">

                    <!-- Comments -->
                    <div class="mb-1">

                        <?php $__currentLoopData = $replies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="d-flex mt-3">
                                <div class="flex-shrink-0">
                                    <div class=" me-3 ">
                                        <?php if(!empty($users[$reply->admin_id]->photo)): ?>
                                            <a href="javascript:" class=" avatar avatar-md rounded-circle ">
                                                <img alt="" class="avatar rounded-circle flex-shrink-0"
                                                     src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($users[$reply->admin_id]->photo); ?>">
                                            </a>
                                        <?php else: ?>
                                            <div
                                                class="avatar avatar-md rounded-circle bg-purple-light  border-radius-md p-2">
                                                <h6 class="text-purple mt-1"><?php echo e($users[$reply->admin_id]->first_name[0]); ?><?php echo e($users[$reply->admin_id]->last_name[0]); ?></h6>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="fw-bolder mt-0">
                                        <?php if($reply->admin_id): ?>
                                            <?php if(!empty($users[$reply->admin_id])): ?>
                                                <?php echo e($users[$reply->admin_id]->first_name); ?> <?php echo e($users[$reply->admin_id]->last_name); ?>

                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </h6>
                                    <p class="text-sm">
                                        <?php echo $reply->message; ?>

                                    </p>
                                    <small class="text-xs"><?php echo e($reply->created_at->diffForHumans()); ?></small>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex mt-4">
                            <div class="flex-shrink-0">
                            </div>
                            <div class="flex-grow-1 my-auto">
                                <form method="post" action="/save-project-message">
                                    <?php if($errors->any()): ?>
                                        <div class="alert alert-danger">
                                            <ul class="list-unstyled">
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>

                                    <textarea class="form-control ms-2" name="message" placeholder="Write your comment"
                                              rows="2"></textarea>

                                    <input type="hidden" name="project_id" value="<?php echo e($project->id); ?>">

                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-info  ms-2 btn-sm mt-3"><?php echo e(__('Send')); ?></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/projects/project-discussions.blade.php ENDPATH**/ ?>