<?php $__env->startSection('content'); ?>

    <div class=" row">
        <div class="col">
            <h5 class="mb-2 text-secondary fw-bolder">
                <?php echo e(__(' McKinsey 7-S Model')); ?>

            </h5>
        </div>
        <div class="col text-end">
            <a href="/new-mckinsey-model" type="button" class="btn btn-info">
                <?php echo e(__('New mckinsey 7-S Model')); ?>

            </a>
        </div>
    </div>


    <div>
        <div class="row">
            <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 col-12 mt-lg-0 mb-4">
                    <div class="card mb-3 mt-lg-0 mt-4">
                        <div class="card-body pb-0">
                            <div class="row">
                                <div class="col-11">
                                    <div class="d-flex">

                                        <?php
                                            $initial = $model->company_name['0'];
                                            $bgColors = ['primary', 'secondary', 'success', 'warning', 'info', 'dark'];
                                            $bgIndex = array_search($initial, range('A', 'Z')) % count($bgColors);
                                            $bgColor = $bgColors[$bgIndex]
                                        ?>

                                        <div class="avatar rounded-circle avatar-sm me-2 bg-<?php echo e($bgColor); ?> border-radius-md p-2">
                                            <h5 class="mt-2 text-white text-uppercase"><?php echo e($initial); ?></h5>
                                        </div>
                                        <a href="/view-mckinsey-model?id=<?php echo e($model->id); ?>"><h5 class="fw-bolder"><?php echo e($model->company_name); ?></h5></a>
                                    </div>

                                    <p class="text-sm mt-2"><?php echo e(__('Related Product')); ?>:<span class="text-dark fw-bolder"> <?php if(!empty($products[$model->product_id])): ?>
                                                <?php if(isset($products[$model->product_id])): ?>
                                                    <?php echo e($products[$model->product_id]->title); ?>

                                                <?php endif; ?>
                                            <?php endif; ?></span></p>
                                    <p class="text-sm"><?php echo e(__('Designed By')); ?>:<span class="text-purple fw-bolder"> <?php if(isset($users[$model->admin_id])): ?>
                                                <?php echo e($users[$model->admin_id]->first_name); ?> <?php echo e($users[$model->admin_id]->last_name); ?>

                                            <?php endif; ?></span></p>
                                    <p class="text-sm"><?php echo e(__('Created At')); ?>:
                                        <span class="badge bg-light text-dark"> <?php echo e((\App\Supports\DateSupport::parse($model->updated_at))->format(config('app.date_format'))); ?></span></p>





                                </div>
                                <div class="col-1 text-end">
                                    <div class="dropstart">
                                        <a href="javascript:" class="text-secondary" id="dropdownMarketingCard"
                                           data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-lg-start px-2 py-3"
                                            aria-labelledby="dropdownMarketingCard">
                                            <li><a class="dropdown-item border-radius-md"
                                                   href="/new-mckinsey-model?id=<?php echo e($model->id); ?>"><?php echo e(__('Edit')); ?></a></li>

                                            <li><a class="dropdown-item border-radius-md"
                                                   href="/view-mckinsey-model?id=<?php echo e($model->id); ?>"><?php echo e(__('See Details')); ?></a></li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li><a class="dropdown-item border-radius-md text-danger"
                                                   href="/delete/mckinsey/<?php echo e($model->id); ?>"><?php echo e(__('Delete')); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <h5 class="text-secondary text-sm"><?php echo e((\App\Supports\DateSupport::parse($model->updated_at))->format(config('app.date_time_format'))); ?></h5>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/mckinsey/list.blade.php ENDPATH**/ ?>