<?php $__env->startSection('content'); ?>

    <div class="">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header pb-0">
                        <h6><?php echo e(__('Users')); ?></h6>
                        <div class="float-end">
                            <a class="btn bg-gradient-dark mb-0" href="/add-user"><i class="fas fa-plus"></i>&nbsp;&nbsp;
                                <?php echo e(__(' Add New User')); ?>

                            </a>

                        </div>

                    </div>

                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0">
                                <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('User')); ?></th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Mobile Number')); ?></th>
                                    <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Workspace Name')); ?></th>
                                    <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Account Created')); ?></th>
                                    <th class="text-secondary opacity-7"></th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workspace_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div>
                                                    <?php if(empty($workspace_user['photo'])): ?>
                                                        <div class="avatar avatar-md bg-gradient-dark border-radius-md p-2 ">
                                                            <h1 class="text-white text-sm"><?php echo e($workspace_user->first_name['0']); ?></h1>
                                                        </div>
                                                    <?php else: ?>

                                                        <img src="<?php echo e(asset($workspace_user['photo'])); ?>"alt="bruce" class="w-100 border-radius-lg shadow-sm">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="d-flex flex-column justify-content-center px-3" >
                                                    <h6 class="mb-0 text-sm"><?php echo e($workspace_user->first_name); ?> <?php echo e($workspace_user->last_name); ?></h6>
                                                    <p class="text-xs text-secondary mb-0"><?php echo e($workspace_user->email); ?></p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($workspace_user->phone_number); ?></p>

                                        </td>
                                        <td class="align-middle text-center text-sm">
                                            <?php if(!empty($workspaces[$workspace_user->workspace_id])): ?>
                                                <?php echo e($workspaces[$workspace_user->workspace_id]->name); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td class="align-middle text-center">
                                            <span class="text-secondary text-xs font-weight-bold"><?php echo e($workspace_user->created_at); ?></span>
                                        </td>
                                        <td class="align-middle">
                                            <div class="ms-auto text-end">

                                                <a class="btn btn-link text-dark px-3 mb-0" href="/user-profile?id=<?php echo e($workspace_user->id); ?>"><i class="fas fa-file-alt text-dark me-2" aria-hidden="true"></i><?php echo e(__('View')); ?></a>

                                                <?php if($user->id != $workspace_user->id): ?>

                                                    <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete-user/<?php echo e($workspace_user->id); ?>"><i class="far fa-trash-alt me-2"></i><?php echo e(__('Delete')); ?></a>

                                                <?php endif; ?>

                                            </div>

                                        </td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/super-admin/users.blade.php ENDPATH**/ ?>