<?php $__env->startSection('content'); ?>
    <h5 class="mb-3"><?php echo e(__('Pricing Page Text Editor')); ?></h5>

    <div class="btn-group mt-2">
        <button type="button" class="btn ms-auto btn-dark btn-icon-only " data-bs-toggle="offcanvas" data-bs-target="#hero" aria-controls="offcanvasRight">
        <span class="btn-inner--icon">
<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class=" mb-2 feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
        </span>
        </button>
        <a href="/pricing" target="_blank" type="button" class="btn btn-success btn-icon-only">
            <span class="btn-inner--icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle>
                </svg>
            </span>
        </a>

    </div>


    <div class="offcanvas offcanvas-end" tabindex="-1" id="hero" aria-labelledby="offcanvasRightLabel">
        <div class="offcanvas-header">
            <h5 id="offcanvasRightLabel"><?php echo e(__('Hero Section ')); ?></h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <form action="/save-pricing-hero-section" method="post" enctype="multipart/form-data">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="list-unstyled">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="offcanvas-body">

                <div class="mb-3">
                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Title')); ?></label>
                    <input type="text" name="hero_title" class="form-control" id="title"  value="<?php echo e($landingpage->hero_title ?? old('hero_title') ?? ''); ?>">
                </div>
                <div class="mb-3">
                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Subtitle')); ?></label>
                    <input type="text" name="hero_subtitle" value="<?php echo e($landingpage->hero_subtitle ?? old('hero_subtitle') ?? ''); ?>" class="form-control" id="title">
                </div>

                <?php echo csrf_field(); ?>

                <?php if(!empty($landingpage)): ?>
                    <input type="hidden" name="id" value="<?php echo e($landingpage->id); ?>">
                <?php endif; ?>
                <div class="button-row text-left mt-4">
                    <button class="btn bg-gradient-dark ms-auto mb-0 js-btn-next" type="submit" title="Next"><?php echo e(__('Save')); ?></button>
                </div>

            </div>
        </form>
    </div>

    <section class="">
        <div class="bg-dark position-relative">
            <img src="" class="position-absolute start-0 top-md-0 w-100 opacity-6">
            <div class="pb-lg-9 pb-7 pt-7 postion-relative z-index-2">
                <div class="row mt-4">
                    <div class="col-md-8 mx-auto text-center">
                        <span class="badge bg-gradient-info mb-2"><?php echo e(__('Pricing')); ?></span>

                        <h1 class="text-white">
                            <?php if(!empty($landingpage)): ?>
                            <?php echo e($landingpage->hero_title); ?>

                            <?php endif; ?>
                        </h1>
                        <p class="text-white mb-4">
                            <?php if(!empty($landingpage)): ?>
                                <?php echo e($landingpage->hero_subtitle); ?>

                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="">
            <div class="mt-sm-n5 mt-n4">
                <div class="container">
                    <div class="">
                        <div class="row">
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <div class="<?php if(count($plans) == 3): ?> <?php if($loop->iteration == 1): ?> col-lg-3 mb-lg-auto mb-4 my-auto p-md-0 ms-auto <?php elseif($loop->iteration == 2): ?> col-lg-3 p-md-0 mb-lg-auto mb-4 z-index-2 <?php elseif($loop->iteration == 3): ?> col-lg-3 mb-lg-auto mb-4 my-auto p-md-0 me-auto <?php endif; ?> <?php endif; ?>">
                                    <div class="card <?php if(count($plans) == 3): ?> <?php if($loop->iteration == 1): ?> bg-white <?php elseif($loop->iteration == 2): ?> bg-purple-light <?php elseif($loop->iteration == 3): ?> bg-white <?php endif; ?> <?php endif; ?>">
                                        <div class="card-header mt-4 <?php if(count($plans) == 3): ?> <?php if($loop->iteration == 1): ?> bg-white <?php elseif($loop->iteration == 2): ?> bg-purple-light <?php elseif($loop->iteration == 3): ?> bg-white <?php endif; ?> <?php endif; ?> text-center ">
                                            <h6 class="text-dark opacity-8 text mb-0"><?php echo e($plan->name); ?></h6>
                                            
                                            <p><?php echo $plan->description; ?></p>

                                            <h2 class=" font-weight-bolder mt-3">
                                                <?php echo e(formatCurrency($plan->price_monthly,getWorkspaceCurrency($settings))); ?><small class="text-sm text-secondary font-weight-bold">/ <?php echo e(__(' month')); ?></small>
                                            </h2>

                                            <h2 class=" font-weight-bolder mt-3">
                                                <?php echo e(formatCurrency($plan->price_yearly,getWorkspaceCurrency($settings))); ?> <small class="text-sm text-secondary font-weight-bold">/ <?php echo e(__(' year')); ?></small>
                                            </h2>

                                        </div>
                                        <div class="card-body mx-auto pt-0">
                                            <?php if($plan->features): ?>

                                                <?php $__currentLoopData = json_decode($plan->features); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <div class=" justify-content-start d-flex px-2 py-1">
                                                        <div>
                                                            <i class="fas fa-check text-purple text-sm"></i>
                                                        </div>
                                                        <div class="ps-2">
                                                            <span class="text-sm"><?php echo e($feature); ?></span>
                                                        </div>
                                                    </div>


                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <?php endif; ?>
                                        </div>
                                        <div class="card-footer text-center pt-0">
                                            <a href="/signup" type="button"
                                               class="btn w-100  <?php if($loop->iteration == 1): ?> btn-dark <?php elseif($loop->iteration == 2): ?> btn-info <?php elseif($loop->iteration == 3): ?> col-lg-3 btn-dark <?php endif; ?>
                                                   mb-0 "><?php echo e(__('Get Started')); ?></a>

                                        </div>
                                    </div>
                                </div>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </section>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/super-admin/pricing-page-editor.blade.php ENDPATH**/ ?>