<?php $__env->startSection('content'); ?>



    <div class="page-header mb-4 border-radius-xl">
        <span class="mask bg-purple-light"></span>
        <div class="container">
            <div class="row">


                <div class="col-lg-6 my-auto">

                    <h4 class="text-purple fadeIn2 fadeInBottom mt-4">
                        <?php echo e(__('“Sooner or later, those who win are those who think they can.”')); ?>

                    </h4>
                    <p class="text-purple opacity-8 fadeIn3 fadeInBottom"><?php echo e(__('— Paul Tournier')); ?> </p>
                </div>
            </div>
            <a  href="/create-project" type="button" class="btn btn-success"><?php echo e(__('Create Project')); ?></a>


        </div>
    </div>


    <div class="">
        <section class="py-3">
            <div class="row">
                <div class="col-md-8 me-auto text-left">
                    <h5><?php echo e(__('List of your awesome projects')); ?></h5>

                </div>
            </div>
            <div class="row mt-lg-4 mt-2">
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="card card-blog bg-yellow-light">
                            <div class="card-body p-3">
                                <div class="d-flex">
                                    <div class="avatar avatar-xl bg-gradient-dark border-radius-md p-2">
                                        <h1 class="text-white"><?php echo e($project->title['0']); ?></h1>
                                    </div>
                                    <div class="ms-3 my-auto">
                                        <h6><?php echo e($project->title); ?></h6>

                                    </div>



                                </div>

                                <p class="text-sm mt-3"> <?php echo e($project->summary); ?> </p>
                                <span class="badge bg-purple-light font-weight-bold"><?php echo e($project->status); ?></span>
                                <hr class="horizontal dark">
                                <div class="row">
                                    <div class="col-6 ">
                                        <h6 class="text-sm mb-0">
                                            <?php if(!empty($project->start_date)): ?>
                                                <?php echo e($project->start_date->format(config('app.date_format'))); ?>

                                            <?php endif; ?></h6>
                                        <p class="text-secondary text-sm font-weight-bold mb-0"><?php echo e(__('Start date')); ?></p>
                                    </div>
                                    <div class="col-6 text-end">
                                        <h6 class="text-sm mb-0"><?php if(!empty($project->end_date)): ?>
                                                <?php echo e($project->end_date->format(config('app.date_format'))); ?>

                                            <?php endif; ?></h6>
                                        <p class="text-secondary text-sm font-weight-bold mb-0"><?php echo e(__('Due date')); ?></p>
                                    </div>
                                    <div class="btn-group">
                                        <a href="/view-project?id=<?php echo e($project->id); ?>" type="button" class="btn btn-success mt-3"><?php echo e(__('View')); ?></a>
                                        <a href="/create-project?id=<?php echo e($project->id); ?>" type="button" class="btn btn-info mt-3"><?php echo e(__('Edit')); ?></a>
                                        <a href="/delete/project/<?php echo e($project->id); ?>" type="button" class="btn btn-warning mt-3"><?php echo e(__('Delete')); ?></a>

                                    </div>
                                </div>


                            </div>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body d-flex flex-column justify-content-center text-center">
                            <a href="/create-project">
                                <i class="fa fa-plus text-secondary mb-3"></i>
                                <h5 class=" text-secondary"><?php echo e(__('New project')); ?> </h5>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/projects/projects.blade.php ENDPATH**/ ?>