<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="font-weight-bolder"><?php echo e(__('SWOT Analysis')); ?></h4>
                    <hr>
                    <form method="post" action="/save-swot">
                        <?php if($errors->any()): ?>
                            <div class="alert bg-pink-light text-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>


                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleFormControlTextarea1">
                                            <?php echo e(__('Business/Company Name')); ?>

                                        </label><label class="text-danger">*</label>
                                        <input class="form-control" name="company_name" id="company_name"
                                               <?php if(!empty($model)): ?>
                                               value="<?php echo e($model->company_name); ?>"
                                            <?php endif; ?>
                                        >
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="">

                                        <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Select Product')); ?></label>
                                        <select class="form-select form-select-solid fw-bolder" id="contact"
                                                aria-label="Floating label select example" name="product_id">
                                            <option value="0"><?php echo e(__('None')); ?></option>
                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($product->id); ?>"
                                                        <?php if(!empty($model)): ?>
                                                        <?php if($model->product_id === $product->id): ?>
                                                        selected
                                                    <?php endif; ?>
                                                    <?php endif; ?>
                                                ><?php echo e($product->title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        <div class="row mt-4">
                            <div class="col align-self-end">
                                <div class="col align-self-center">
                                    <div class="form-group">
                                        <label for="exampleFormControlTextarea1">
                                            <?php echo e(__('Strengths')); ?>

                                        </label>
                                        <p class="form-text text-muted text-xs ms-1">
                                            <?php echo e(__('What are the strengths?')); ?>


                                        </p>
                                        <textarea class="form-control mt-4" rows="10" id="strengths"
                                                  name="strengths"><?php if(!empty($model)): ?><?php echo e($model->strengths); ?><?php endif; ?></textarea>
                                        <?php if(!empty($super_settings['openai_api_key'])): ?>
                                            <button class="btn btn-info mt-4" type="submit" id="generate_strengths"><?php echo e(__('Generate with AI')); ?></button>
                                        <?php endif; ?>
                                        <button class="btn bg-success-light text-success shadow-none mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Weaknesses')); ?>

                                    </label>
                                    <p class="form-text text-muted text-xs ms-1">
                                        <?php echo e(__('What are the weaknesses?')); ?>


                                    </p>
                                    <textarea class="form-control mt-4" rows="10" id="weaknesses"
                                              name="weaknesses"><?php if(!empty($model)): ?><?php echo e($model->weaknesses); ?><?php endif; ?></textarea>
                                    <?php if(!empty($super_settings['openai_api_key'])): ?>
                                        <button class="btn btn-info mt-4" type="submit" id="generate_weaknesses"><?php echo e(__('Generate with AI')); ?></button>
                                    <?php endif; ?>
                                    <button class="btn bg-success-light text-success shadow-none mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                                </div>
                            </div>
                        </div>
                            <div class="row mt-4">
                                <div class="col align-self-end">
                                    <div class="col align-self-center">
                                        <div class="form-group">
                                        <label for="exampleFormControlTextarea1">
                                            <?php echo e(__('Opportunities')); ?>

                                        </label>
                                        <p class="form-text text-muted text-xs ms-1">
                                            <?php echo e(__('What are the opportunities?')); ?>

                                        </p>
                                        <textarea class="form-control mt-4" rows="10" id="opportunities"
                                                  name="opportunities"><?php if(!empty($model)): ?><?php echo e($model->opportunities); ?><?php endif; ?></textarea>
                                            <?php if(!empty($super_settings['openai_api_key'])): ?>
                                                <button class="btn btn-info mt-4" type="submit" id="generate_opportunities"><?php echo e(__('Generate with AI')); ?></button>
                                            <?php endif; ?>
                                            <button class="btn bg-success-light text-success shadow-none mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Threats')); ?>

                                    </label>
                                    <p class="form-text text-muted text-xs ms-1">
                                        <?php echo e(__('What are the Threats?')); ?>

                                    </p>
                                    <textarea class="form-control mt-4" rows="10" id="threats"
                                              name="threats"><?php if(!empty($model)): ?><?php echo e($model->threats); ?><?php endif; ?></textarea>
                                    <?php if(!empty($super_settings['openai_api_key'])): ?>
                                        <button class="btn btn-info mt-4" type="submit" id="generate_threats"><?php echo e(__('Generate with AI')); ?></button>
                                    <?php endif; ?>
                                    <button class="btn bg-success-light text-success shadow-none mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                                </div>
                            </div>
                        </div>
                        <?php if($model): ?>
                            <input type="hidden" name="id" value="<?php echo e($model->id); ?>">
                        <?php endif; ?>
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-info mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        (function(){
            "use strict";
            tinymce.init({
                selector: '#strengths',

                plugins: 'lists,table',
                toolbar: 'styleselect | forecolor | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link image | code | undo redo|numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
                menubar: false,
            });
            tinymce.init({
                selector: '#weaknesses',

                plugins: 'lists,table',
                toolbar: 'styleselect | forecolor | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link image | code | undo redo|numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
                menubar: false,
            });
            tinymce.init({
                selector: '#threats',
                plugins: 'lists,table',
                toolbar: 'styleselect | forecolor | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link image | code | undo redo|numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
                menubar: false,
            });
            tinymce.init({
                selector: '#opportunities',
                plugins: 'lists,table',
                toolbar: 'styleselect | forecolor | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link image | code | undo redo|numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
                menubar: false,
            });

            <?php if(!empty($super_settings['openai_api_key'])): ?>

            let generate_strengths = document.getElementById('generate_strengths');
            let strengths = document.getElementById('strengths');

            generate_strengths.addEventListener('click',function (e) {
                e.preventDefault();

                generate_strengths.disabled = true;
                generate_strengths.innerHTML = '<i class="fa fa-spinner fa-spin"></i> <?php echo e(__('Generating')); ?>';

                axios.post('/swot-ai',{
                    _token:'<?php echo e(csrf_token()); ?>',
                    company_name:'<?php echo e($model->company_name ?? ''); ?>',
                    action: 'strengths',
                }).then(function (response) {
                    tinymce.get("strengths").setContent(response.data.message);

                    generate_strengths.disabled = false;
                    generate_strengths.innerHTML = '<?php echo e(__('Generate')); ?>';

                }).catch(function (error) {
                    console.log(error);
                });
            });


            let generate_weaknesses = document.getElementById('generate_weaknesses');
            let weaknesses = document.getElementById('weaknesses');

            generate_weaknesses.addEventListener('click',function (e) {
                e.preventDefault();

                generate_weaknesses.disabled = true;
                generate_weaknesses.innerHTML = '<i class="fa fa-spinner fa-spin"></i> <?php echo e(__('Generating')); ?>';

                axios.post('/swot-ai',{
                    _token:'<?php echo e(csrf_token()); ?>',
                    company_name:'<?php echo e($model->company_name ?? ''); ?>',
                    action: 'weaknesses',
                }).then(function (response) {
                    tinymce.get("weaknesses").setContent(response.data.message);

                    generate_weaknesses.disabled = false;
                    generate_weaknesses.innerHTML = '<?php echo e(__('Generate')); ?>';

                }).catch(function (error) {
                    console.log(error);
                });
            });


            let generate_opportunities = document.getElementById('generate_opportunities');
            let opportunities = document.getElementById('value_propositions');

            generate_opportunities.addEventListener('click',function (e) {
                e.preventDefault();

                generate_opportunities.disabled = true;
                generate_opportunities.innerHTML = '<i class="fa fa-spinner fa-spin"></i> <?php echo e(__('Generating')); ?>';

                axios.post('/swot-ai',{
                    _token:'<?php echo e(csrf_token()); ?>',
                    company_name:'<?php echo e($model->company_name ?? ''); ?>',
                    action: 'opportunities',
                }).then(function (response) {
                    tinymce.get("opportunities").setContent(response.data.message);

                    generate_opportunities.disabled = false;
                    generate_opportunities.innerHTML = '<?php echo e(__('Generate')); ?>';

                }).catch(function (error) {
                    console.log(error);
                });
            });

            let generate_threats = document.getElementById('generate_threats');
            let threats = document.getElementById('threats');

            generate_threats.addEventListener('click',function (e) {
                e.preventDefault();

                generate_threats.disabled = true;
                generate_threats.innerHTML = '<i class="fa fa-spinner fa-spin"></i> <?php echo e(__('Generating')); ?>';

                axios.post('/swot-ai',{
                    _token:'<?php echo e(csrf_token()); ?>',
                    company_name:'<?php echo e($model->company_name ?? ''); ?>',
                    action: 'threats',
                }).then(function (response) {
                    tinymce.get("threats").setContent(response.data.message);

                    generate_threats.disabled = false;
                    generate_threats.innerHTML = '<?php echo e(__('Generate')); ?>';

                }).catch(function (error) {
                    console.log(error);
                });
            });



            <?php endif; ?>




        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/swot/write-swot.blade.php ENDPATH**/ ?>