<?php $__env->startSection('content'); ?>



    <div class="row">
        <div class="col-md-5">
            <div class="card">
                <div class="card-header">
                    Add Todos
                    <a href="/todos" type="submit" class="btn bg-gradient-secondary float-end">Go to List</a>
                </div>

                <div class="card-body">
                    <form action="/save-todos" method="post">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <?php if($for === 'project'): ?>

                            <div class="mb-3">
                                <label>Project</label>
                                <select class="form-select" name="project_id">
                                    <option value="">--</option>
                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <option value="<?php echo e($project->id); ?>"><?php echo e($project->title); ?></option>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <?php elseif($for === 'goal'): ?>
                                <label>Goal</label>
                                <select class="form-select" name="goal_id">
                                    <option value="">--</option>
                                    <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <option value="<?php echo e($goal->id); ?>"><?php echo e($goal->name); ?></option>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            <?php endif; ?>

                        <div class="form-group">
                            <label for="example-date-input" class="form-control-label">Date</label>
                            <input class="form-control" name="date" type="date" value="<?php echo e(date('Y-m-d')); ?>" id="date">
                        </div>
                        <div class="form-group">
                            <label for="example-text-input" class="form-control-label">Task</label><span class="text-danger">*</span>
                            <input class="form-control"  name="title" type="text" id="title" <?php if(!empty($todo)): ?> value="<?php echo e($todo->title); ?>"<?php endif; ?>>
                        </div>

                        <div class="mb-3">
                            <label for="exampleFormControlTextarea1">Description</label><span class="text-danger">*</span>
                            <textarea class="form-control" name="description" id="description" rows="3"><?php if(!empty($todo)): ?> <?php echo e($todo->description); ?><?php endif; ?>  </textarea>
                        </div>

                        <?php echo csrf_field(); ?>
                        <?php if($todo): ?>
                            <input type="hidden" name="id" value="<?php echo e($todo->id); ?>">
                        <?php endif; ?>
                        <button type="submit" class="btn bg-gradient-secondary">Save</button>
                        <button type="button" class="btn bg-gradient-primary">Close</button>
                    </form>

                </div>

            </div>
        </div>




        <?php if($for === 'project'): ?>

            <div class="col-md-7">
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="mb-0">Project Todo list</h6>
                            </div>

                        </div>
                        <hr class="horizontal dark mb-0">
                    </div>
                    <div class="card-body p-3 pt-0">
                        <ul class="list-group list-group-flush" data-toggle="checklist">
                            <?php $__currentLoopData = $todos_projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                <li class="list-group-item border-0 flex-column align-items-start ps-0 py-0 mb-3">
                                    <div class="checklist-item checklist-item-primary ps-2 ms-3">
                                        <div class="d-flex align-items-center">


                                            <div class="form-check">
                                                <input class="form-check-input todo_checkbox" type="checkbox"
                                                       data-id="<?php echo e($todo->id); ?>"

                                                       <?php if($todo->completed): ?> checked <?php endif; ?>

                                                >

                                            </div>
                                            <h6 class="mb-0 text-dark font-weight-bold text-sm"><?php echo e($todo->title); ?></h6>
                                            <div class="dropdown float-lg-end ms-auto pe-4">
                                                <a href="javascript:;" class="cursor-pointer" id="dropdownTable2" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete/today-todo/<?php echo e($todo->id); ?>"><i class="far fa-trash-alt me-2"></i>Delete</a>
                                                    <a class="btn btn-link text-dark px-3 mb-0" href="/add-task/?id=<?php echo e($todo->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i>Edit</a>
                                                </a>

                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center ms-4 mt-3 ps-1">
                                            <div>
                                                <p class="text-xs mb-0 text-secondary font-weight-bold">Date</p>
                                                <span class="text-xs font-weight-bolder"><?php echo e($todo->date); ?></span>
                                            </div>

                                        </div>
                                    </div>
                                    <hr class="horizontal dark mt-4 mb-0">
                                </li>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                        </ul>
                    </div>
                </div>

            </div>

        <?php elseif($for === 'goal'): ?>
            <div class="col-md-7">
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="mb-0">Goal Todo list</h6>
                            </div>
                            <div class="col-md-6 d-flex justify-content-end align-items-center">
                                <small>23 - 30 March 2020</small>
                            </div>
                        </div>
                        <hr class="horizontal dark mb-0">
                    </div>
                    <div class="card-body p-3 pt-0">
                        <ul class="list-group list-group-flush" data-toggle="checklist">
                            <?php $__currentLoopData = $todos_goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                <li class="list-group-item border-0 flex-column align-items-start ps-0 py-0 mb-3">
                                    <div class="checklist-item checklist-item-primary ps-2 ms-3">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check">
                                                <input class="form-check-input todo_checkbox" type="checkbox"
                                                       data-id="<?php echo e($todo->id); ?>"

                                                       <?php if($todo->completed): ?> checked <?php endif; ?>
                                                >
                                            </div>
                                            <h6 class="mb-0 text-dark font-weight-bold text-sm"><?php echo e($todo->title); ?></h6>
                                            <div class="dropdown float-lg-end ms-auto pe-4">
                                                <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete/today-todo/<?php echo e($todo->id); ?>"><i class="far fa-trash-alt me-2"></i>Delete</a>
                                                <a class="btn btn-link text-dark px-3 mb-0" href="/add-task/?id=<?php echo e($todo->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i>Edit</a>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center ms-4 mt-3 ps-1">
                                            <div>
                                                <p class="text-xs mb-0 text-secondary font-weight-bold">Date</p>
                                                <span class="text-xs font-weight-bolder"><?php echo e($todo->date); ?></span>
                                            </div>

                                        </div>

                                    </div>

                                    <hr class="horizontal dark mt-4 mb-0">
                                </li>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                        </ul>
                    </div>
                </div>

            </div>


        <?php elseif($for === null): ?>
            <div class="col-md-7">
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="mb-0">To do list</h6>
                            </div>
                            <div class="col-md-6 d-flex justify-content-end align-items-center">
                                <small>23 - 30 March 2020</small>
                            </div>
                        </div>
                        <hr class="horizontal dark mb-0">
                    </div>
                    <div class="card-body p-3 pt-0">
                        <ul class="list-group list-group-flush" data-toggle="checklist">
                            <?php $__currentLoopData = $todos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                <li class="list-group-item border-0 flex-column align-items-start ps-0 py-0 mb-3">
                                    <div class="checklist-item checklist-item-primary ps-2 ms-3">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check">
                                                <input class="form-check-input todo_checkbox" type="checkbox"
                                                data-id="<?php echo e($todo->id); ?>"

                                                       <?php if($todo->completed): ?> checked <?php endif; ?>

                                                >
                                            </div>
                                            <h6 class="mb-0 text-dark font-weight-bold text-sm"><?php echo e($todo->title); ?></h6>
                                            <div class="dropdown float-lg-end ms-auto pe-4">
                                                <a href="javascript:;" class="cursor-pointer" id="dropdownTable2" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete/today-todo/<?php echo e($todo->id); ?>"><i class="far fa-trash-alt me-2"></i>Delete</a>
                                                    <a class="btn btn-link text-dark px-3 mb-0" href="/add-task/?id=<?php echo e($todo->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i>Edit</a>
                                                </a>

                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center ms-4 mt-3 ps-1">
                                            <div>
                                                <p class="text-xs mb-0 text-secondary font-weight-bold">Date</p>
                                                <span class="text-xs font-weight-bolder"><?php echo e($todo->date); ?></span>
                                            </div>

                                        </div>
                                    </div>
                                    <hr class="horizontal dark mt-4 mb-0">
                                </li>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                        </ul>
                    </div>
                </div>

            </div>





        <?php endif; ?>



    </div>






<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>

    <script>
        $(function () {


            flatpickr("#date", {

                dateFormat: "Y-m-d",
            });



        });




    </script>

    <script>
        tinymce.init({
            selector: '#description',


            plugins: 'table,code,advlist',


        });
    </script>
    <script>
        $(function () {
            $('.todo_checkbox').on('change',function () {
                let that = $(this);
                if(this.checked)
                {
                   $.post('/todos/change-status',{
                       id: that.attr('data-id'),
                       status: 'Completed',
                       _token: '<?php echo e(csrf_token()); ?>',
                   });
                }
                else{
                    $.post('/todos/change-status',{
                        id: that.attr('data-id'),
                        status: 'Not Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
            });
        });
    </script>


<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.marketing_crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/marketing-crm/resources/views/actions/add-task.blade.php ENDPATH**/ ?>