
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>
        <?php echo e(config('app.name')); ?>

    </title>


    <link id="pagestyle" href="<?php echo e(PUBLIC_DIR); ?>/css/app.css" rel="stylesheet" />
</head>

<body class="g-sidenav-show  bg-gray-100">


<section class="min-vh-100 mb-8">
    <div class="page-header align-items-start min-vh-50 pt-5 pb-11 m-3 border-radius-lg">
        <span class="mask bg-brown"></span>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5 text-center mx-auto">
                    <h1 class="text-warning mb-2 mt-5"><?php echo e(__('Welcome!')); ?></h1>
                    <p class="text-lead text-white"><?php echo e(__('Create new account')); ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row mt-lg-n10 mt-md-n11 mt-n10">
            <div class="col-xl-4 col-lg-5 col-md-7 mx-auto">
                <div class="card z-index-0">
                    <div class="card-header text-center pt-4">
                        <h5><?php echo e(__('Register')); ?></h5>
                    </div>

                    <div class="card-body">
                        <form role="form text-left"  method="post" action="/signup">

                            <?php if(session()->has('status')): ?>
                                <div class="alert alert-success">
                                    <?php echo e(session('status')); ?>

                                </div>
                            <?php endif; ?>

                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul class="list-unstyled">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                                <label><?php echo e(__('First Name')); ?></label>
                                <div class="mb-3">
                                    <input  name="first_name" class="form-control"  type="text"  placeholder="First name" aria-describedby="email-addon">
                                </div>
                                <label><?php echo e(__('Last Name')); ?></label>
                                <div class="mb-3">
                                    <input type="text" name="last_name" class="form-control"    placeholder="Last name" aria-describedby="email-addon">
                                </div>

                                <label><?php echo e(__('Email')); ?></label>
                                <div class="mb-3">
                                    <input type="email" placeholder="Email" name="email" class="form-control"  aria-label="Email" aria-describedby="email-addon">
                                </div>
                                <label><?php echo e(__('Choose Password')); ?></label>
                                <div class="mb-3">
                                    <input type="password" name="password" class="form-control" placeholder="Password" aria-label="Password" aria-describedby="password-addon">
                                </div>


                                <?php echo csrf_field(); ?>
                            <div class="text-center">
                                <button type="submit" class="btn btn-warning w-100 my-4 mb-2"><?php echo e(__('Sign up')); ?></button>
                            </div>
                            <p class="text-sm mt-3 mb-0"><?php echo e(__('Already have an account?')); ?> <a href="/login" class="text-dark font-weight-bolder"><?php echo e(__('Sign in')); ?></a></p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    "use strict"
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
        var options = {
            damping: '0.5'
        }
        Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
</script>

</body>

</html>
<?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/auth/signup.blade.php ENDPATH**/ ?>