<?php $__env->startSection('content'); ?>

    <div class=" row">
        <div class="col">
            <h5 class=" text-secondary fw-bolder">
                <?php echo e(__('Product Ideas')); ?>

            </h5>
        </div>
        <div class="col text-end">
            <a href="/create-project" type="button" class="btn btn-info text-white"><?php echo e(__('Plan Product ')); ?></a>
        </div>
    </div>
    <div class="card ">
        <div class=" card-body table-responsive">
            <table class="table align-items-center mb-0" id="cloudonex_table">
                <thead>
                <tr>
                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Product Name')); ?></th>
                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Members')); ?></th>

                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Due Date')); ?></th>
                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Status')); ?></th>

                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Action')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <a href="/view-project?id=<?php echo e($project->id); ?>">
                                <div class="d-flex px-2">
                                    <?php
                                        $initial = $project->title['0'];
                                        $bgColors = ['primary', 'secondary', 'success', 'warning', 'info', 'dark'];
                                        $bgIndex = array_search($initial, range('A', 'Z')) % count($bgColors);
                                        $bgColor = $bgColors[$bgIndex]
                                    ?>

                                    <div class="avatar avatar-sm me-3 bg-<?php echo e($bgColor); ?>  border-radius-md p-2">
                                        <h5 class="mt-2 text-white text-uppercase"><?php echo e($initial); ?></h5>
                                    </div>

                                    <div class="my-auto">

                                        <h6 class="text-sm mb-0 ms-1"><?php echo e($project->title); ?></h6>
                                    </div>
                                </div>
                            </a>

                        </td>
                        <td class="">

                            <div class="avatar-group d-flex mt-2">
                                <?php if($project->members): ?>
                                    <?php $__currentLoopData = json_decode($project->members); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($users[$member])): ?>

                                            <?php if(!empty($users[$member]->photo)): ?>
                                                <a href="javascript:" class="avatar avatar-sm rounded-circle"
                                                   data-bs-toggle="tooltip" data-bs-placement="bottom"
                                                   title="<?php echo e($users[$member]->first_name); ?>">
                                                    <img src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($users[$member]->photo); ?>"
                                                         alt="team1">
                                                </a>

                                            <?php else: ?>
                                                <?php
                                                    $initial = $users[$member]->first_name[0];
                                                    $bgColors = ['light', 'purple-light','pink-light','success-light', ];
                                                    $bgIndex = array_search($initial, range('A', 'Z')) % count($bgColors);
                                                    $bgColor = $bgColors[$bgIndex]
                                                ?>
                                                <div class="avatar avatar-sm  rounded-circle bg-<?php echo e($bgColor); ?>">
                                                    <p class="mt-3 text-dark fw-bold text-uppercase"><span><?php echo e($initial); ?></span>
                                                    </p>
                                                </div>

                                            <?php endif; ?>

                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                <?php endif; ?>


                            </div>
                        </td>

                        <td>
                            <p class="text-xs font-weight-bold mb-0">

                                <?php if(!empty($project->end_date)): ?>
                                    <?php echo e((\App\Supports\DateSupport::parse($project->end_date))->format(config('app.date_format'))); ?>


                                <?php endif; ?>
                            </p>
                        </td>

                        <td>
                            <span class="badge badge-dot me-4">
                            <i class="bg-info"></i>
                                <?php if($project->status == 'Started'): ?>
                                    <span class="badge bg-primary font-weight-bold"> <?php echo e($project->status); ?></span>

                                <?php elseif($project->status == 'Pending'): ?>
                                    <span class="badge bg-warning"><?php echo e($project->status); ?></span>
                                <?php elseif($project->status == 'Finished'): ?>
                                    <span class="badge bg-success"><?php echo e($project->status); ?></span>
                                <?php endif; ?>

                            </span>
                        </td>
                        <td>
                            <div>
                                <div class="dropstart">
                                    <a href="javascript:" class="text-secondary" id="dropdownMarketingCard"
                                       data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-lg-start px-2 py-3"
                                        aria-labelledby="dropdownMarketingCard">
                                        <li><a class="dropdown-item border-radius-md"
                                               href="/create-project?id=<?php echo e($project->id); ?>"><?php echo e(__('Edit')); ?></a></li>

                                        <li><a class="dropdown-item border-radius-md"
                                               href="/view-project?id=<?php echo e($project->id); ?>"><?php echo e(__('See Details')); ?></a>
                                        </li>
                                        <li>
                                            <hr class="dropdown-divider">
                                        </li>
                                        <li>
                                            <a class="dropdown-item border-radius-md text-danger"
                                               href="/delete/project/<?php echo e($project->id); ?>"><?php echo e(__('Delete')); ?>

                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>

    <script>
        "use strict";
        $(document).ready(function () {
            $('#cloudonex_table').DataTable(
            );

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/projects/projects.blade.php ENDPATH**/ ?>