<?php $__env->startSection('content'); ?>

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-lg-9 col-12 mx-auto">
                <div class="card card-body">
                    <h6 class="mb-0"><?php echo e(__('New Plan')); ?></h6>
                    <p class="text-sm mb-0"><?php echo e(__('Create new plan')); ?></p>
                    <form action="/save-subscription-plan" method="post">
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <hr class="horizontal dark my-3">
                        <label for="projectName" class="form-label"><?php echo e(__('Plan Name')); ?></label>
                        <input type="text" class="form-control" name="name" <?php if(!empty($plan)): ?> value="<?php echo e($plan->name); ?>"<?php endif; ?> id="projectName">
                        <div class="row mt-4">
                            <label>
                                <?php echo e(__('Pricing')); ?>

                            </label>
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('Monthly')); ?></label>
                                <input class="form-control datetimepicker" type="text" name="price_monthly" <?php if(!empty($plan)): ?> value="<?php echo e($plan->price_monthly); ?>"<?php endif; ?> data-input>
                            </div>
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('Yearly')); ?></label>
                                <input class="form-control datetimepicker" name="price_yearly" type="text" <?php if(!empty($plan)): ?> value="<?php echo e($plan->price_yearly); ?>"<?php endif; ?> data-input>
                            </div>
                        </div>

                            <label class="text-uppercase text-body text-xs font-weight-bolder mt-4"><?php echo e(__('Modules')); ?></label>


                            <ul class="list-group">


                                <?php $__currentLoopData = $available_modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                    <li class="list-group-item border-0 px-0">
                                        <div class="form-check form-switch ps-0">
                                            <input class="form-check-input ms-auto" type="checkbox" id="module_<?php echo e($key); ?>" name="<?php echo e($key); ?>" value="1"
                                            <?php if(!empty($plan_modules) && in_array($key,$plan_modules)): ?> checked <?php endif; ?>
                                            >
                                            <label class="form-check-label text-body ms-3 text-truncate w-80 mb-0" for="module_<?php echo e($key); ?>"><?php echo e($value); ?></label>
                                        </div>
                                    </li>


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </ul>


                        <label class="mt-4"><?php echo e(__('Description')); ?></label>

                        <div class="form-group">
                            <textarea class="form-control" rows="10" <?php if(!empty($plan)): ?> value="<?php echo e($plan->description); ?>"<?php endif; ?> id="description" name="description">
                            </textarea>
                        </div>


                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Features')); ?></label>
                            <div id="div_features">
                                <div class="row feature_row">
                                    <div class="col-md-9">
                                        <input type="text" class="form-control" name="features[]">
                                    </div>
                                    <div class="col-md-3 text-end">
                                        <button class="btn btn-sm btn-danger btn_remove_feature"><i class="fas fa-minus"></i> </button>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="mb-3">
                            <button class="btn btn-sm btn-dark" id="btn_add_feature"><i class="fas fa-plus"></i> </button>
                        </div>



                         <?php echo csrf_field(); ?>
                        <?php if($plan): ?>
                            <input type="hidden" name="id" value="<?php echo e($plan->id); ?>">
                        <?php endif; ?>
                        <div class="d-flex  mt-4">

                            <button type="submit" name="button" class="btn bg-gradient-primary m-0 "><?php echo e(__('Save')); ?></button>
                        </div>

                    </form>

                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script>
        "use strict";
        $(function () {


            flatpickr("#start_date", {

                dateFormat: "Y-m-d",
            });

            flatpickr("#end_date", {

                dateFormat: "Y-m-d",
            });


            tinymce.init({
                selector: '#description',


                plugins: 'table,code',


            });

            let $btn_add_feature = $('#btn_add_feature');
            let $div_features = $('#div_features');


            $btn_add_feature.on('click',function (event) {
                event.preventDefault();
                $div_features.append('<div class="row feature_row"><div class="col-md-9"><input type="text" class="form-control" name="features[]"></div><div class="col-md-3 text-end"><button class="btn btn-sm btn-danger btn_remove_feature"><i class="fas fa-minus"></i> </button></div></div>');


            });

            let $clx_body = $('#clx_body');



            $clx_body.on('click','.btn_remove_feature',function (event) {
                event.preventDefault();
                $(this).closest('.feature_row').remove();
            });



        });


    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/super-admin/create-plan.blade.php ENDPATH**/ ?>