<?php $__env->startSection('head'); ?>
    <style>
        .row {
            display: flex;
            flex-wrap: wrap;
            padding: 0 8px;
        }

        /* Create two equal columns that sits next to each other */
        .column {
            flex: 50%;
            padding: 0 8px;
        }

        .column img {
            margin-top: 8px;
            vertical-align: middle;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <form action="/vision-board" class="form-control dropzone" id="dropzone">
        <div class="fallback">
            <input name="file" type="file" multiple />
        </div>
    </form>



    <!-- Gallery -->


    <div class="row mt-4">
        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="column">

            <img
                src="<?php echo e(url($image->path)); ?>"
                class="w-100 shadow-1-strong rounded mb-3"
                alt=""
            />
            <a  href="/delete/image/<?php echo e($image->id); ?>" class="btn btn-outline-dark rounded-circle p-2 mb-0" type="button" data-bs-toggle="tooltip" data-bs-placement="top" title="Next">
                <i class="fas fa-trash p-2"></i>
            </a>





        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    </div>
























    <!-- Gallery -->


<?php $__env->stopSection(); ?>




<?php $__env->startSection('script'); ?>
    <script>


        Dropzone.autoDiscover = false;
        Dropzone.options.dropzone = {
            acceptedFiles:'image/*'
        };

        $(function () {
            $("#dropzone").dropzone({
                url: "/vision-board",
                success: function (file, response) {
                    location.reload();
                },
                error: function (file, response) {
                    file.previewElement.classList.add("dz-error");
                },
                sending: function(file, xhr, formData){
                    formData.append('_token', '<?php echo e(csrf_token()); ?>');
                }
            });
        })
    </script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.marketing_crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/marketing-crm/resources/views/goals/vision-board.blade.php ENDPATH**/ ?>