<div class="card-body mt-4 table-responsive  pt-0">
    <!--begin::Table-->
    <table class="table align-items-center mb-0" id="cloudonex_table">
        <!--begin::Table head-->
        <thead>
        <!--begin::Table row-->
        <tr>
            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Subject/Task')); ?></th>
            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Assigned To')); ?></th>

            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Start Date')); ?></th>
            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Due Date')); ?></th>
            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Status')); ?>

            </th>
            <th class=" text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end "><?php echo e(__('Actions')); ?></th>
        </tr>
        </thead>

        <tbody>
        <!--begin::Table row-->

        <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <tr>
                <td class="">
                    <h6 class="text-sm font-weight-bold mb-0"><?php echo e($task->subject); ?> </h6>
                </td>


                <td class=" text-sm fw-bolder mb-0">

                    <div class="d-flex">
                        <div class="avatar avatart-sm rounded-circle">
                            <?php if(isset($users[$task->contact_id])): ?>
                                <?php if(!empty($users[$task->contact_id]->photo)): ?>
                                    <a href="javascript:" class="avatar avatar-sm rounded-circle"
                                       data-bs-toggle="tooltip" data-bs-placement="bottom"  title="<?php echo e($users[$task->contact_id]->first_name); ?>">
                                        <img src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($users[$task->contact_id]->photo); ?>">
                                    </a>

                                <?php else: ?>

                                    <?php
                                        $initial = $users[$task->contact_id]->first_name[0];
                                        $bgColors = ['dark','primary','info','secondary'];
                                        $bgIndex = array_search($initial, range('A', 'Z')) % count($bgColors);
                                        $bgColor = $bgColors[$bgIndex]
                                    ?>
                                    <div class="avatar  avatar-sm rounded-circle bg-<?php echo e($bgColor); ?>"><p class=" mt-3 text-white text-uppercase"><?php echo e($initial); ?></p>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="text-sm fw-bold mt-2 ms-1 ">
                            <?php if(isset($users[$task->contact_id])): ?>
                                <?php echo e($users[$task->contact_id]->first_name); ?> <?php echo e($users[$task->contact_id]->last_name); ?>


                            <?php endif; ?>
                        </div>
                    </div>



                </td>


                <td>
                    <p class="text-xs font-weight-bold text-dark mb-0">
                        <?php if(!empty($task->start_date)): ?>
                            <?php echo e((\App\Supports\DateSupport::parse($task->start_date))->format(config('app.date_time_format'))); ?>


                        <?php endif; ?>
                    </p>
                </td>
                <td>
                    <p class="text-xs font-weight-bold text-dark mb-0">
                        <?php if(!empty($task->due_date)): ?>
                            <?php echo e($task->due_date->format(config('app.date_time_format'))); ?>

                        <?php endif; ?>
                    </p>

                </td>
                <td>
                    <div class="dropdown mt-2">
                        <button class="text-xs btn btn-sm
                                         <?php if($task->status === 'Not Started'): ?>
                            btn-info
<?php elseif($task->status === 'done'): ?>
                            btn-success
<?php elseif($task->status === 'in_progress'): ?>
                           btn-primary
<?php elseif($task->status === 'in_review'): ?>
                            btn-warning
<?php else: ?>
                            btn-secondary
<?php endif; ?>
                            dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown"
                                aria-expanded="false">
                            <?php echo e($task->status ?? 'todo'); ?>

                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <?php if($task->status !== 'todo'): ?>
                                <li><a class="dropdown-item change_task_status" data-id="<?php echo e($task->id); ?>"
                                       data-status="todo" href="#"><?php echo e(__('Mark as Todo')); ?></a></li>
                            <?php endif; ?>
                                <?php if($task->status !== 'in_progress'): ?>
                                    <li><a class="dropdown-item change_task_status" data-id="<?php echo e($task->id); ?>"
                                           data-status="in_progress" href="#"><?php echo e(__('Mark as In Progress')); ?></a></li>
                                <?php endif; ?>
                            <?php if($task->status !== 'in_review'): ?>
                                <li><a class="dropdown-item change_task_status" data-id="<?php echo e($task->id); ?>"
                                       data-status="in_review" href="#"><?php echo e(__('Mark as In Review')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if($task->status !== 'done'): ?>
                                <li><a class="dropdown-item change_task_status" data-id="<?php echo e($task->id); ?>"
                                       data-status="done" href="#"><?php echo e(__('Mark as Done')); ?></a></li>
                            <?php endif; ?>

                        </ul>
                    </div>
                </td>
                <!--begin::Joined-->
                <!--begin::Action=-->
                <td class="text-end">

                    <!--begin::Menu-->
                    <div class="menu-item px-3">
                        <a href="#" class="btn btn-link text-dark px-3 mb-0 category_edit"
                           data-id="<?php echo e($task->id); ?>"><?php echo e(__('Edit')); ?></a>
                        <a href="/delete/task/<?php echo e($task->id); ?>" class="btn btn-link text-danger px-3 mb-0"
                           data-kt-users-table-filter="delete_row"><?php echo e(__('Delete')); ?></a>
                    </div>
                    <!--end::Menu-->
                </td>
                <!--end::Action=-->
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
        <!--end::Table body-->
    </table>
    <!--end::Table-->

    <div class="modal fade" tabindex="-1" id="kt_modal_1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Add Task')); ?></h5>

                </div>

                <form method="post" id="form_main">

                    <div class="modal-body">
                        <div id="sp_result_div"></div>
                        <div class="">
                            <label for="exampleFormControlInput1"
                                   class="required form-label"><?php echo e(__('Subject/Task')); ?></label>
                            <input type="text" id="input_name" name="subject" class="form-control form-control-solid"
                                   placeholder=""/>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div>
                                    <label for="exampleFormControlInput1"
                                           class="required form-label"><?php echo e(__('Start Date')); ?></label>
                                    <input type="text" placeholder="Pick Date" id="start_date" name="start_date"
                                           <?php if(!empty($task)): ?> value="<?php echo e($task->start_date); ?>"
                                           <?php endif; ?> class="form-control form-control-solid flatpickr-input"/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('End Date')); ?></label>
                                    <input type="text" id="due_date" name="due_date"
                                           class="form-control form-control-solid"
                                           <?php if(!empty($task)): ?>
                                           value="<?php echo e($task->due_date); ?>"
                                           <?php endif; ?> placeholder="Pick Date"/>
                                </div>
                            </div>

                        </div>
                        <div class="mb-1 mt-2">

                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Assign To')); ?></label>
                            <select class="form-select form-select-solid fw-bolder" id="contact"
                                    aria-label="Floating label select example" name="contact_id">
                                <option value="0"><?php echo e(__('None')); ?></option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"
                                            <?php if(!empty($task)): ?>
                                            <?php if($task->contact_id === $user->id): ?>
                                            selected
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    ><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-2">

                                    <label for="exampleFormControlInput1"
                                           class="form-label"><?php echo e(__('Description')); ?></label>
                                    <textarea type="text" name="description" id="description"
                                              class="form-control form-control-solid"
                                              rows="7"><?php if(!empty($task)): ?><?php echo e($task->description); ?><?php endif; ?> </textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="ms-3">
                        <?php echo csrf_field(); ?>
                        <button type="submit" id="btn_submit" class="btn btn-info"><?php echo e(__('Save')); ?> </button>
                        <button type="button" class="btn bg-pink-light text-danger"
                                data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    </div>
                    <input type="hidden" name="task_id" id="task_id" value="">
                </form>
            </div>
        </div>
    </div>
</div>


<?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/tasks/tabs/list_view.blade.php ENDPATH**/ ?>