<?php $__env->startSection('content'); ?>








    <div class="card mb-3 mt-4">

        <div class="card-header pb-0 p-3">
            <div class="row">
                <div class="col-md-6 d-flex align-items-center">
                    <h6 class="mb-0">Form Properties</h6>
                </div>
                <div class="col-md-6 text-right">
                    <a class="btn bg-gradient-dark mb-0" href="/lead-capture">&nbsp;&nbsp;Go to the form List</a>
                </div>
            </div>
        </div>
        <div class="card-body  p-3">
            <form action="/lead-capture-post" method="post">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <label for="example-text-input" class="form-control-label">Name <span class="text-danger">*</span></label>
                    <input class="form-control" type="text" name="name" <?php if(!empty($selected_form)): ?> value="<?php echo e($selected_form->name); ?>" <?php endif; ?> id="example-text-input">
                </div>
                <div class="form-group">
                    <label for="example-tel-input" class="form-control-label">Audience</label>
                    <select class="form-select" aria-label="Default select example" name="audience_id">
                        <?php $__currentLoopData = $audiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $audience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($audience->id); ?>"
                                    <?php if(!empty($selected_form)): ?>
                                    <?php if($selected_form->audience_id == $audience->id): ?>
                                    selected
                                <?php endif; ?>
                                <?php endif; ?>
                            ><?php echo e($audience->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="example-text-input" class="form-control-label">Header Title <span class="text-danger">*</span></label>
                    <input class="form-control" name="header_title" <?php if(!empty($selected_form)): ?> value="<?php echo e($selected_form->header_title); ?>" <?php endif; ?> id="example-text-input">
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea1">Header Text <span class="text-danger">*</span></label>
                    <textarea class="form-control" name="header_text" id="exampleFormControlTextarea1" rows="3"><?php if(!empty($selected_form)): ?><?php echo e($selected_form->header_text); ?><?php endif; ?></textarea>
                </div>


                <h4 class="mb-3">Form Fields</h4>

                    <?php $__currentLoopData = $available_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-check form-switch">

                            <input class="form-check-input connect_with" value="1" type="checkbox" name="has_<?php echo e($key); ?>" id="has_<?php echo e($key); ?>"
                                   <?php if($selected_form): ?>
                                   <?php if($selected_form->{'has_'.$key}): ?> checked <?php endif; ?>
                                   <?php else: ?>
                                   <?php if($value['default']['checked']): ?> checked <?php endif; ?>
                                <?php endif; ?>
                                   data-connected-to="div_<?php echo e($key); ?>"
                            >

                                <label class="form-check-label" for="has_<?php echo e($key); ?>" data-connected-to="div_<?php echo e($key); ?>"
                                ><?php echo e($value['default']['name']); ?></label>

                        </div>

                        <div id="div_<?php echo e($key); ?>"

                             <?php if($selected_form): ?>

                             <?php if(!$selected_form->{'has_'.$key}): ?> style="display: none;" <?php endif; ?>

                             <?php else: ?>
                             <?php if(!$value['default']['checked']): ?> style="display: none;" <?php endif; ?>
                             <?php endif; ?>

                        >
                        <div class="mb-3">
                            <label for="input_div_<?php echo e($key); ?>"><?php echo e($value['label']); ?></label>
                            <input class="form-control" name="label_<?php echo e($key); ?>" id="input_div_<?php echo e($key); ?>"
                                   value="<?php echo e($selected_form->{'label_'.$key} ?? $value['default']['name'] ?? ''); ?>"
                            >
                        </div>

                        <div class="mb-3">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="required_<?php echo e($key); ?>" name="required_<?php echo e($key); ?>" value="1"

                                <?php if($selected_form): ?>
                                    <?php if($selected_form->{'required_'.$key}): ?> checked <?php endif; ?>
                                <?php else: ?>
                                    <?php if($value['default']['required']): ?> checked <?php endif; ?>
                                <?php endif; ?>
                                >
                                <label class="custom-control-label" for="required_<?php echo e($key); ?>">Required</label>
                            </div>
                        </div>

        </div>

        <hr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>










                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault" checked="">
                    <label class="form-check-label" for="flexSwitchCheckDefault">Checked switch</label>
                </div>
                <div class="form-group">
                    <label for="example-text-input" class="form-control-label">Button Label</label>
                    <input class="form-control" type="text" value="John Snow" id="example-text-input">
                </div>
                <h4 class="mt-3">Rules</h4>
                <div class="form-group">
                    <label for="example-tel-input" class="form-control-label">After Submission Action</label>
                    <select class="form-select" aria-label="Default select example">

                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
                <h4 class="mt-3">Resources</h4>
                <div class="form-group">
                    <label for="example-tel-input" class="form-control-label">Documents</label>
                    <select class="form-select" aria-label="Default select example">
                        <option>--</option>

                        <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($document->id); ?>"
                                    <?php if(!empty($selected_form)): ?>
                                    <?php if($selected_form->document_id == $document->id): ?>
                                    selected
                                <?php endif; ?>
                                <?php endif; ?>
                            ><?php echo e($document->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="example-url-input" class="form-control-label">Video URL</label>
                    <input class="form-control" type="url" name="video_url" <?php if(!empty($selected_form)): ?> value="<?php echo e($selected_form->video_url); ?>" <?php endif; ?>  id="example-url-input">
                </div>
                <div class="form-group">
                    <label for="example-url-input" class="form-control-label"> Page URL</label>
                    <input class="form-control" name="page_url" <?php if(!empty($selected_form)): ?> value="<?php echo e($selected_form->page_url); ?>" <?php endif; ?> id="example-url-input">
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea1">After Submission Text</label>
                    <textarea class="form-control" name="after_submission_text" id="exampleFormControlTextarea1" rows="3"><?php if(!empty($selected_form)): ?><?php echo e($selected_form->after_submission_text); ?><?php endif; ?></textarea>
                </div>
                <?php echo csrf_field(); ?>
                <?php if($selected_form): ?>
                    <input type="hidden" name="id" value="<?php echo e($selected_form->id); ?>">
                <?php endif; ?>

                    <?php if($type): ?>

                        <input type="hidden" name="type" value="<?php echo e($type); ?>">

                    <?php endif; ?>

                <button class="btn btn-primary" type="submit">Save</button>

            </form>

        </div>
    </div>







<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script>

        $(function () {

            let $connect_with = $('.connect_with');

            $connect_with.on('change',function () {

                let that = $(this);

                let connected_with = that.attr('data-connected-to');


                if(that.is(":checked"))
                {
                    let $connected_with = $('#' + connected_with);
                    $connected_with.show('fast');
                    $('#input_' + connected_with).focus();

                }
                else{
                    $('#' + connected_with).hide('slow');
                }

            });

            let $btn_submit = $('#btn_submit');
            let $form_main = $('#form_main');
            let $sp_result_div = $('#sp_result_div');

            $form_main.on('submit',function (event) {
                event.preventDefault();
                $btn_submit.prop('disabled',true);
                $.post(base_url + 'marketing/save-form',$form_main.serialize()).done(function (data) {
                    window.location = base_url + 'marketing/form/' + data.id;
                }).fail(function (data) {
                    let errors = $.parseJSON(data.responseText);
                    $btn_submit.prop('disabled',false);
                    let html = '';
                    $.each(errors, function(key,value) {
                        html += '<div class="alert alert-danger">'+ value +'</div>'
                    });

                    $sp_result_div.html(html);

                });

            });


        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.marketing_crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/marketing-crm/resources/views/contacts/lead-capture-form.blade.php ENDPATH**/ ?>