<?php $__env->startSection('content'); ?>
    <div class=" row">
        <div class="col">
            <h5 class="mb-2 text-secondary fw-bolder">
                <?php echo e(__('SWOT Analysis')); ?>

            </h5>
        </div>
        <div class="col text-end">
            <a href="/write-swot" type="button" class="btn btn-info " data-bs-toggle="modal" data-bs-target="#exampleModal">  <?php echo e(__('New SWOT Analysis')); ?></a>

        </div>
    </div>




    <div>
        <div class="row">
            <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6 col-12 mt-lg-0 mb-3">
                    <div class="card mb-3 mt-lg-0 mt-4">
                        <div class="card-body pb-0">
                            <div class="row">
                                <div class="col-md-11">
                                    <div class="d-flex">

                                        <?php
                                            $initial = $model->company_name['0'];
                                            $bgColors = ['primary', 'secondary', 'success', 'warning', 'info', 'dark'];
                                            $bgIndex = array_search($initial, range('A', 'Z')) % count($bgColors);
                                            $bgColor = $bgColors[$bgIndex]
                                        ?>

                                        <div class="avatar rounded-circle avatar-sm me-2 bg-<?php echo e($bgColor); ?> border-radius-md p-2">
                                            <h5 class="mt-2 text-white text-uppercase"><?php echo e($initial); ?></h5>
                                        </div>
                                        <h5 class=" fw-bolder text-dark text-primary">
                                            <a href="/view-swot?id=<?php echo e($model->id); ?>"><?php echo e($model->company_name); ?></a>

                                        </h5>
                                    </div>

                                    <p class="text-sm mt-2"><?php echo e(__('Related Product')); ?>:<span class="text-dark fw-bolder"> <?php if(!empty($products[$model->product_id])): ?>
                                                <?php if(isset($products[$model->product_id])): ?>
                                                    <?php echo e($products[$model->product_id]->title); ?>

                                                <?php endif; ?>
                                            <?php endif; ?></span></p>
                                    <p class="text-sm"><?php echo e(__('Designed By')); ?>:<span class="text-purple fw-bolder"> <?php if(isset($users[$model->admin_id])): ?>
                                                <?php echo e($users[$model->admin_id]->first_name); ?> <?php echo e($users[$model->admin_id]->last_name); ?>

                                            <?php endif; ?></span></p>
                                    <p class="text-sm"><?php echo e(__('Created At')); ?>:
                                        <span class="badge bg-info"> <?php echo e((\App\Supports\DateSupport::parse($model->updated_at))->format(config('app.date_format'))); ?></span></p>



                                </div>
                                <div class="col-1 text-end">
                                    <div class="dropstart">
                                        <a href="javascript:" class="text-secondary" id="dropdownMarketingCard"
                                           data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-lg-start px-2 py-3"
                                            aria-labelledby="dropdownMarketingCard">
                                            <li><a class="dropdown-item border-radius-md"
                                                   href="/write-swot?id=<?php echo e($model->id); ?>"><?php echo e(__('Edit')); ?></a></li>

                                            <li><a class="dropdown-item border-radius-md"
                                                   href="/view-swot?id=<?php echo e($model->id); ?>"><?php echo e(__('See Details')); ?></a></li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li><a class="dropdown-item border-radius-md text-danger"
                                                   href="/delete/swot/<?php echo e($model->id); ?>"><?php echo e(__('Delete')); ?></a></li>
                                        </ul>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>


    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel"><?php echo e(__('Business Model Canvas')); ?></h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" action="/save-swot">
                        <?php if($errors->any()): ?>
                            <div class="alert bg-pink-light text-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="form-group">
                                <label for="exampleFormControlTextarea1">
                                    <?php echo e(__('Business/Company Name')); ?>

                                </label><label class="text-danger">*</label>
                                <input class="form-control" name="company_name" id="company_name">
                            </div>

                        </div>
                        <div class="">

                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Select Product')); ?></label>
                            <select class="form-select form-select-solid fw-bolder" id="contact"
                                    aria-label="Floating label select example" name="product_id">
                                <option value="0"><?php echo e(__('None')); ?></option>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product->id); ?>"
                                            <?php if(!empty($model)): ?>
                                            <?php if($model->product_id === $product->id): ?>
                                            selected
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    ><?php echo e($product->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>



                        <?php echo csrf_field(); ?>
                        <button class="btn btn-info mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                        <button type="button" class="btn btn-secondary mt-4" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    </form>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/swot/list.blade.php ENDPATH**/ ?>